/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterWriter;
import com.arm.streamline.analysis.gator.emeter.EnergyMeterCounters;
import com.arm.streamline.analysis.model.DBProperties;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.model.session.EnergyCaptureSettings;
import com.arm.utils.function.IThrowingFunction;
import gnu.trove.set.TIntSet;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EnergyMeterCounterAnalysis
extends AnalysisBase {
    private final @NonNull IAnalysisReaderFactoryV2 analysisReaderFactory;
    private final @NonNull IThrowingFunction<@NonNull CounterRecord, @NonNull IAnalysisHardwareCounterWriter, IOException> counterWriterSupplier;
    private final @NonNull EnergyCaptureSettings energyCaptureSettings;
    private final @Nullable Integer energyDelta;
    private final @NonNull TIntSet idleUtids;
    private final @NonNull File apcPath;

    public EnergyMeterCounterAnalysis(@NonNull File apcPath, @NonNull TIntSet idleUtids, @NonNull SessionProcessor sp, @NonNull EnergyCaptureSettings ecs, @Nullable Integer energyDelta, @NonNull IAnalysisReaderFactoryV2 analysisReaderFactory, @NonNull IThrowingFunction<@NonNull CounterRecord, @NonNull IAnalysisHardwareCounterWriter, IOException> counterWriterSupplier) {
        super(sp);
        this.idleUtids = idleUtids;
        this.apcPath = apcPath;
        this.energyCaptureSettings = ecs;
        this.energyDelta = energyDelta;
        this.analysisReaderFactory = analysisReaderFactory;
        this.counterWriterSupplier = counterWriterSupplier;
        this.setName("EnergyMeterCounterAnalysis", apcPath.getAbsolutePath());
        this.setPriorityLower();
        this.start();
    }

    @Override
    protected void process() {
        try {
            if (new File(this.apcPath, "energy").isDirectory()) {
                @NonNull DBProperties stateReader = this.analysisReaderFactory.getDbProperties();
                long stopTime = stateReader.getDurationInNanosecs();
                new EnergyMeterCounters().process(this.analysisReaderFactory, this.counterWriterSupplier, this.apcPath, this.getHandler(), this.energyCaptureSettings, this.energyDelta, this.idleUtids, stopTime);
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }
}

