/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.elfdwarf;

import com.arm.streamline.protocol.misc.ApkEntries;
import com.arm.streamline.protocol.misc.ApkEntry;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.eclipse.jdt.annotation.NonNull;

public class ApkContentExtractor {
    public static @NonNull ApkEntries extractApkContent(@NonNull File apkFile, @NonNull String zipFileName) throws IOException {
        @NonNull HashMap<@NonNull String, @NonNull ApkEntry> entryMap = new HashMap<String, ApkEntry>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zf = new ZipFile(apkFile);){
            Iterator entryIterator = zf.getEntries().asIterator();
            while (entryIterator.hasNext()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)entryIterator.next();
                String name = zipEntry.getName();
                if (!zipEntry.isStreamContiguous() || zipEntry.getMethod() != 0) continue;
                long baseOffset = zipEntry.getDataOffset();
                long length = zipEntry.getSize();
                ApkEntry apkEntry = new ApkEntry(baseOffset, length, zipFileName, name);
                entryMap.put(name, apkEntry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new ApkEntries(Collections.unmodifiableMap(entryMap));
    }
}

