/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.database;

import com.arm.streamline.analysis.database.DBPropertiesReaderWriter;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseFactory;
import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.analysis.dbnative.io.IFileDataView;
import com.arm.streamline.analysis.dbnative.io.MMappedFileDataView;
import com.arm.streamline.analysis.dbnative.metadata.Metadata;
import com.arm.streamline.analysis.model.DBProperties;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public final class DatabaseUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkVersionAndDeleteInvalidDB(@NonNull String apcDirectory, boolean forceDelete) throws IOException {
        File indexDbFile;
        @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)new File(apcDirectory));
        if (!dbDirectory.exists()) return false;
        if (!dbDirectory.isDirectory()) return false;
        if (!forceDelete && DatabaseUtils.isValid(apcDirectory) && (indexDbFile = new File(dbDirectory, "index.db")).exists()) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (MMappedFileDataView viewMetadata = new MMappedFileDataView(indexDbFile);){
                ByteOrder byteOrder = Metadata.validateMetadataHeader((IFileDataView)viewMetadata);
                if (byteOrder != null) {
                    return true;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        FileUtils.delete((File)dbDirectory);
        dbDirectory.mkdirs();
        return false;
    }

    public static String getName(@NonNull String apcDirectory) {
        if (!DatabaseUtils.isValid(apcDirectory)) {
            return null;
        }
        try {
            @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)new File(apcDirectory));
            @NonNull DBProperties state = DatabaseLayout.readDatabaseProperties((File)dbDirectory);
            return state.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isValid(@NonNull String apcDirectory) {
        @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)new File(apcDirectory));
        return DBPropertiesReaderWriter.isValid((File)new File(dbDirectory, "state.xml")) && AnalysisDatabaseFactory.isValidVersion((File)dbDirectory);
    }
}

