/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.IInterruptible;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.warnings.WarningItem;
import java.io.File;
import java.nio.channels.ClosedByInterruptException;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AnalysisBase
implements Runnable,
IInterruptible {
    private Thread mThread;
    private String mThreadName = "Analysis";
    private int mThreadPriority = 5;
    private boolean mIsInterrupted;
    private int mProgress = -1;
    private @NonNull IAnalysisHandler mHandler;

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public AnalysisBase(@NonNull IAnalysisHandler handler) {
        this.mHandler = handler;
    }

    public void close() {
    }

    public @NonNull IAnalysisHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void interrupt() {
        this.mIsInterrupted = true;
        Thread thread = this.mThread;
        if (thread != null) {
            thread.interrupt();
        }
    }

    public void join() {
        Thread thread = this.mThread;
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException exception) {
                thread.interrupt();
            }
            while (thread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.mThread = null;
        }
    }

    @Override
    public final void run() {
        try {
            this.process();
        }
        catch (OutOfMemoryError exception) {
            this.mHandler.error((Throwable)new Exception(AnalysisMessages.OUT_OF_MEMORY_MESSAGE));
            exception.printStackTrace();
        }
        catch (Throwable exception) {
            this.mHandler.error(exception);
            exception.printStackTrace();
        }
    }

    public void start() {
        this.mThread = new Thread(this);
        this.mThread.setName(this.mThreadName);
        this.mThread.setDaemon(true);
        this.mThread.setPriority(this.mThreadPriority);
        this.mThread.start();
    }

    protected void cancel() {
        this.mHandler.cancel();
    }

    protected void error(Exception exception) {
        if (!(exception instanceof ClosedByInterruptException) && !(exception instanceof InterruptedException)) {
            this.mHandler.error((Throwable)exception);
        }
    }

    protected boolean isInterrupted() {
        if (Thread.interrupted()) {
            this.mIsInterrupted = true;
        }
        return this.mIsInterrupted;
    }

    protected abstract void process();

    protected void progress(int progress) {
        if (progress > 100) {
            progress = 100;
        }
        if (progress > this.mProgress) {
            this.mProgress = progress;
            this.mHandler.progress((Object)this, progress);
        }
    }

    protected void setName(String name, String input) {
        this.setName(name, input, null);
    }

    protected void setName(String name, String input, String output) {
        if (input != null && !input.isEmpty()) {
            name = String.format("%s '%s'", name, new File(input).getName());
        }
        if (output != null && !output.isEmpty()) {
            name = String.format("%s '%s'", name, new File(output).getName());
        }
        this.mThreadName = name;
    }

    protected void setPriorityHigher() {
        this.mThreadPriority = 6;
    }

    protected void setPriorityHighest() {
        this.mThreadPriority = 10;
    }

    protected void setPriorityLower() {
        this.mThreadPriority = 4;
    }

    protected void setPriorityLowest() {
        this.mThreadPriority = 1;
    }

    protected void setPriorityNormal() {
        this.mThreadPriority = 5;
    }

    protected void throwInterrupted() throws InterruptedException {
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected void warning(@NonNull WarningItem item) {
        this.mHandler.warning(item);
    }
}

