/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.text;

import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.Nullable;

public class BasicTextFilter {
    public static final boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static final String normalizeLineEndings(String text) {
        return BasicTextFilter.normalizeLineEndings(text, System.getProperty("line.separator"));
    }

    public static final @Nullable String normalizeLineEndings(String text, String normalizedLineEnding) {
        String result;
        if (text == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int count = text.length();
        boolean hadCR = false;
        boolean hadLF = false;
        int i = 0;
        while (i < count) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                if (hadLF || hadCR) {
                    buffer.append(normalizedLineEnding);
                    if (hadCR) {
                        buffer.append(normalizedLineEnding);
                    }
                    hadCR = false;
                    hadLF = false;
                } else {
                    hadCR = true;
                }
            } else if (ch == '\n') {
                if (hadLF || hadCR) {
                    buffer.append(normalizedLineEnding);
                    if (hadLF) {
                        buffer.append(normalizedLineEnding);
                    }
                    hadCR = false;
                    hadLF = false;
                } else {
                    hadLF = true;
                }
            } else {
                if (hadLF || hadCR) {
                    buffer.append(normalizedLineEnding);
                    hadCR = false;
                    hadLF = false;
                }
                buffer.append(ch);
            }
            ++i;
        }
        if (hadLF || hadCR) {
            buffer.append(normalizedLineEnding);
        }
        return (result = buffer.toString()).equals(text) ? text : result;
    }

    public static final String wrap(String text, int length) {
        if (text == null) {
            return null;
        }
        StringBuilder all = new StringBuilder();
        StringBuilder line = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(text, "\r\n\t ", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("\n")) {
                all.append(line.toString());
                all.append('\n');
                line.setLength(0);
                continue;
            }
            if (token.startsWith("\r")) continue;
            int len = line.length();
            if (len != 0 && len + token.length() > length) {
                all.append(line.toString());
                all.append('\n');
                line.setLength(0);
                if (" ".equals(token)) {
                    token = "";
                }
            }
            line.append(token);
        }
        all.append(line.toString());
        return all.toString();
    }
}

