/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.numbers;

import com.arm.utils.ArrayUtils;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;

public final class UnsignedLong
extends Number
implements Comparable<UnsignedLong> {
    public static final long MAX_VALUE = -1L;
    public static final long MIN_VALUE = 0L;
    public static final @NonNull UnsignedLong ONE = new UnsignedLong(1);
    public static final @NonNull UnsignedLong ZERO = new UnsignedLong(0);
    private final long value;

    public static int compare(long a, long b) {
        return Long.compareUnsigned(a, b);
    }

    public static long divide(long a, long b) {
        return Long.divideUnsigned(a, b);
    }

    public static long max(long a, long b) {
        return UnsignedLong.compare(a, b) >= 0 ? a : b;
    }

    public static @NonNull UnsignedLong max(@NonNull UnsignedLong a, @NonNull UnsignedLong b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static long min(long a, long b) {
        return UnsignedLong.compare(a, b) <= 0 ? a : b;
    }

    public static @NonNull UnsignedLong min(@NonNull UnsignedLong a, @NonNull UnsignedLong b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static long modulo(long a, long b) {
        return Long.remainderUnsigned(a, b);
    }

    public static long multiply(long a, long b) {
        return a * b;
    }

    public static void sort(long @NonNull [] values) {
        ArrayUtils.sortUnsigned(values);
    }

    public static double toDouble(long value) {
        double dValue = value & Long.MAX_VALUE;
        return dValue + (value < 0L ? 9.223372036854776E18 : 0.0);
    }

    public static @NonNull UnsignedLong valueOf(@NonNull String text, int base) {
        return new UnsignedLong(Long.parseUnsignedLong(text, base));
    }

    public static @NonNull UnsignedLong valueOf(@NonNull String text) {
        return new UnsignedLong(Long.parseUnsignedLong(text));
    }

    public UnsignedLong(byte value) {
        this.value = Byte.toUnsignedLong(value);
    }

    public UnsignedLong(int value) {
        this.value = Integer.toUnsignedLong(value);
    }

    public UnsignedLong(long value) {
        this.value = value;
    }

    public UnsignedLong(short value) {
        this.value = Short.toUnsignedLong(value);
    }

    public @NonNull UnsignedLong add(long that) {
        return new UnsignedLong(this.value + that);
    }

    public @NonNull UnsignedLong add(@NonNull UnsignedLong that) {
        return new UnsignedLong(this.value + that.value);
    }

    @Override
    public int compareTo(UnsignedLong o) {
        return UnsignedLong.compare(this.value, o.value);
    }

    public @NonNull UnsignedLong divide(@NonNull UnsignedLong that) {
        return new UnsignedLong(Long.divideUnsigned(this.value, that.value));
    }

    @Override
    public double doubleValue() {
        return UnsignedLong.toDouble(this.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedLong) {
            UnsignedLong that = (UnsignedLong)obj;
            return this.value == that.value;
        }
        return false;
    }

    @Override
    public float floatValue() {
        float fValue = this.value & Long.MAX_VALUE;
        return fValue + (this.value < 0L ? 9.223372E18f : 0.0f);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public @NonNull UnsignedLong modulo(long that) {
        return new UnsignedLong(Long.remainderUnsigned(this.value, that));
    }

    public @NonNull UnsignedLong modulo(@NonNull UnsignedLong that) {
        return new UnsignedLong(Long.remainderUnsigned(this.value, that.value));
    }

    public @NonNull UnsignedLong multiply(long that) {
        return new UnsignedLong(this.value * that);
    }

    public @NonNull UnsignedLong multiply(@NonNull UnsignedLong that) {
        return new UnsignedLong(this.value * that.value);
    }

    public @NonNull UnsignedLong subtract(long that) {
        return new UnsignedLong(this.value - that);
    }

    public @NonNull UnsignedLong subtract(@NonNull UnsignedLong that) {
        return new UnsignedLong(this.value - that.value);
    }

    public @NonNull BigInteger toBigInteger() {
        return new BigInteger(1, new byte[]{(byte)(this.value >>> 56), (byte)(this.value >>> 48), (byte)(this.value >>> 40), (byte)(this.value >>> 32), (byte)(this.value >>> 24), (byte)(this.value >>> 16), (byte)(this.value >>> 8), (byte)(this.value >>> 0)});
    }

    public @NonNull String toString() {
        return Long.toUnsignedString(this.value);
    }
}

