/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.jdt.annotation.NonNull;

public class InputStreamUtils {
    public static void readFully(@NonNull InputStream inputStream, byte @NonNull [] data) throws IOException {
        int pos = 0;
        while (pos < data.length) {
            int nRead = inputStream.read(data, pos, data.length - pos);
            if (nRead < 0) {
                if (pos == 0) {
                    throw new EOFException();
                }
                throw new IOException("Failed to read array in full (got " + pos + " bytes)");
            }
            pos += nRead;
        }
    }

    public static @NonNull String text(@NonNull InputStream inputStream, @NonNull Charset charset) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(charset);
    }
}

