/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.io;

import com.arm.utils.Platform;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.io.AccessibleByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FileUtils {
    public static @NonNull File canonicalise(@NonNull File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    public static @NonNull String canonicalisePath(@NonNull File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static void copyDirectory(final @NonNull Path source, final @NonNull Path target) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Path newDir = target.resolve(source.relativize(dir));
                FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                Files.setLastModifiedTime(newDir, time);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path newDir = target.resolve(source.relativize(dir));
                try {
                    Files.copy(dir, newDir, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (DirectoryNotEmptyException directoryNotEmptyException) {
                    // empty catch block
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, target.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final @NonNull List<@NonNull File> delete(@NonNull File path) {
        ArrayList<@NonNull File> failedToDelete = new ArrayList<File>();
        if (path.exists()) {
            File[] files;
            if (path.isDirectory() && (files = path.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    failedToDelete.addAll(FileUtils.delete(file));
                    ++n2;
                }
            }
            if (!path.delete()) {
                failedToDelete.add(path);
            }
        }
        return failedToDelete;
    }

    public static final @NonNull List<@NonNull File> deleteContents(@NonNull File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        @NonNull ArrayList<@NonNull File> result = new ArrayList<File>();
        @NonNull File @Nullable [] children = directory.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result.addAll(FileUtils.delete(child));
                ++n2;
            }
        }
        return result;
    }

    public static void deleteDirectory(@NonNull Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static boolean deleteDirectoryIfExists(@NonNull Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return false;
        }
        FileUtils.deleteDirectory(dir);
        return true;
    }

    public static @Nullable File findExecutableIfNotAbsolute(@NonNull String name, @NonNull List<@NonNull File> searchPaths) {
        return FileUtils.findExecutableIfNotAbsolute(name, FileUtils.getPlatformExecutableExtensions(), searchPaths);
    }

    public static @Nullable File findExecutableIfNotAbsolute(@NonNull String name, @NonNull List<@NonNull String> extensions, @NonNull List<@NonNull File> searchPaths) {
        File file = new File(name);
        if (file.isAbsolute() && file.isFile() && file.canExecute()) {
            return file;
        }
        for (File searchPath : searchPaths) {
            file = new File(searchPath, name);
            if (file.exists() && file.isFile() && file.canExecute()) {
                return file;
            }
            for (String extension : extensions) {
                file = new File(searchPath, FileUtils.makeDotName(name, extension));
                if (!file.exists() || !file.isFile() || !file.canExecute()) continue;
                return file;
            }
        }
        return null;
    }

    public static @Nullable File findIfNotAbsolute(@NonNull String path, @NonNull List<@NonNull File> searchPaths) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        for (File searchPath : searchPaths) {
            file = new File(searchPath, path);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static @NonNull List<@NonNull String> getPlatformExecutableExtensions() {
        List<String> extensions;
        if (Platform.isWindows()) {
            String pathext = System.getenv("PATHEXT");
            if (pathext == null || pathext.isEmpty()) {
                pathext = System.getenv("PathExt");
            }
            extensions = pathext == null || pathext.isEmpty() ? Arrays.asList(".exe", ".bat") : FileUtils.splitPathsTrimmed(pathext);
        } else {
            extensions = Collections.emptyList();
        }
        return extensions;
    }

    public static @NonNull List<@NonNull File> getPlatformExecutablePaths() {
        String path = System.getenv("PATH");
        if (Platform.isWindows() && (path == null || path.isBlank())) {
            path = System.getenv("Path");
        }
        @NonNull List<@NonNull File> extensions = path == null || path.isBlank() ? Collections.emptyList() : FileUtils.splitFilePaths(path);
        return extensions;
    }

    /*
     * Loose catch block
     */
    public static byte @NonNull [] readBytes(@NonNull File file) throws IOException {
        long length = file.length();
        int lengthInt = Math.toIntExact(length);
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            byte[] byArray;
            AccessibleByteArrayOutputStream baos;
            FileInputStream fis;
            block17: {
                block16: {
                    int nRead;
                    fis = new FileInputStream(file);
                    baos = new AccessibleByteArrayOutputStream(lengthInt);
                    byte[] buffer = new byte[lengthInt];
                    while ((nRead = fis.read(buffer)) >= 0) {
                        baos.write(buffer, 0, nRead);
                    }
                    byArray = baos.buffer();
                    if (baos == null) break block16;
                    baos.close();
                }
                if (fis == null) break block17;
                fis.close();
            }
            return byArray;
            {
                catch (Throwable throwable2) {
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static @NonNull List<@NonNull String> readLines(@NonNull File localFile) throws IOException {
        ArrayList<@NonNull String> result = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileReader fr = new FileReader(localFile);
            try {
                try (BufferedReader br = new BufferedReader(fr);){
                    String line;
                    while ((line = br.readLine()) != null) {
                        result.add(line);
                    }
                }
                if (fr == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fr == null) throw throwable;
                fr.close();
                throw throwable;
            }
            fr.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static @NonNull File relativeTo(@NonNull String path, @NonNull File root) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(root, path);
    }

    public static <T> @NonNull List<@NonNull T> splitAndMapPaths(@NonNull String path, @NonNull Function<@NonNull String, @NonNull T> mapper) {
        @NonNull LinkedHashSet<@NonNull T> result = new LinkedHashSet<T>();
        int length = path.length();
        int index = 0;
        while (index < length) {
            int sepPos = path.indexOf(File.pathSeparatorChar, index);
            int endPos = sepPos >= index ? sepPos : length;
            int partLen = endPos - index;
            if (partLen > 0) {
                String part = path.substring(index, endPos);
                T mappedValue = mapper.apply(part);
                result.add(mappedValue);
            }
            index = endPos + 1;
        }
        return new ArrayList(result);
    }

    public static @NonNull Pair<@NonNull String, @NonNull String> splitFilename(@NonNull String pattern) {
        int lastDot = pattern.lastIndexOf(46);
        int lastSlash = pattern.lastIndexOf(47);
        int lastBackslash = pattern.lastIndexOf(92);
        if (lastDot > 0 && lastDot > lastSlash + 1 && lastDot > lastBackslash + 1) {
            return new Pair<String, String>(pattern.substring(0, lastDot), pattern.substring(lastDot));
        }
        return new Pair<String, String>(pattern, "");
    }

    public static @NonNull List<@NonNull File> splitFilePaths(@NonNull String path) {
        return FileUtils.splitAndMapPaths(path, p -> FileUtils.canonicalise(new File((String)p)));
    }

    public static @NonNull List<@NonNull String> splitPaths(@NonNull String path) {
        return FileUtils.splitAndMapPaths(path, Function.identity());
    }

    public static @NonNull List<@NonNull String> splitPathsTrimmed(@NonNull String path) {
        return FileUtils.splitAndMapPaths(path, String::trim);
    }

    public static <U extends InputStream, E extends Throwable> U wrapFileInputStream(@NonNull File file, @NonNull IThrowingFunction<? super FileInputStream, U, E> wrapperFactory) throws IOException, E {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            return (U)((InputStream)wrapperFactory.apply(fileInputStream));
        }
        catch (Throwable t) {
            try {
                fileInputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
    }

    public static void writeStreamToFile(@NonNull InputStream is, @NonNull File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            int n;
            byte[] buffer = new byte[0x100000];
            while ((n = is.read(buffer)) >= 0) {
                if (n <= 0) continue;
                fos.write(buffer, 0, n);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static @NonNull String makeDotName(@NonNull String name, @NonNull String suffix) {
        if (name.toLowerCase().endsWith(suffix)) {
            return name;
        }
        return name + suffix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(@NonNull File file) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                ZipFile f = new ZipFile(file);
                if (f == null) return true;
                f.close();
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isElfFile(@NonNull File f) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream is = new FileInputStream(f);){
                byte[] buffer = new byte[4];
                int n = is.read(buffer);
                boolean bl = n == buffer.length && buffer[0] == 127 && buffer[1] == 69 && buffer[2] == 76 && buffer[3] == 70;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

