/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.datainput;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;

public class LittleEndianDataOutput
implements DataOutput {
    private final @NonNull OutputStream output;

    public LittleEndianDataOutput(@NonNull OutputStream output) {
        this.output = output;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 255 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.writeByte(s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeByte(v & 0xFF);
        this.writeByte(v >>> 8 & 0xFF);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int i = 0;
        while (i < s.length()) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeByte(v & 0xFF);
        this.writeByte(v >>> 8 & 0xFF);
        this.writeByte(v >>> 16 & 0xFF);
        this.writeByte(v >>> 24 & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeByte((int)(v & 0xFFL));
        this.writeByte((int)(v >>> 8 & 0xFFL));
        this.writeByte((int)(v >>> 16 & 0xFFL));
        this.writeByte((int)(v >>> 24 & 0xFFL));
        this.writeByte((int)(v >>> 32 & 0xFFL));
        this.writeByte((int)(v >>> 40 & 0xFFL));
        this.writeByte((int)(v >>> 48 & 0xFFL));
        this.writeByte((int)(v >>> 56 & 0xFFL));
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeByte(v & 0xFF);
        this.writeByte(v >>> 8 & 0xFF);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(bytes.length);
        this.write(bytes);
    }
}

