/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.collections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DynamicArrayRingBuffer<T>
implements Iterable<T> {
    private static final int MIN_CAPACITY = 1024;
    private @Nullable T @NonNull [] buffer;
    private int headOffset;
    private final boolean reallyClear;
    private int size;

    private static <T> @Nullable T @NonNull [] newBuffer(int length) {
        return new Object[length];
    }

    public DynamicArrayRingBuffer() {
        this(false, 1024);
    }

    public DynamicArrayRingBuffer(boolean reallyClear, int capacity) {
        this.buffer = DynamicArrayRingBuffer.newBuffer(capacity);
        this.headOffset = 0;
        this.size = 0;
        this.reallyClear = reallyClear;
    }

    public void append(T t) {
        this.ensureCapacity();
        int writePos = this.wrapPos(this.size);
        assert (writePos < this.buffer.length);
        assert (writePos != this.headOffset || this.size == 0);
        this.buffer[writePos] = t;
        ++this.size;
    }

    public int binarySearch(@NonNull ICompareAgainst<? super T> comparator) {
        return this.binarySearch((T)comparator, 0, this.size);
    }

    public int binarySearch(@NonNull ICompareAgainst<? super T> comparator, int fromInclusive, int toExclusive) {
        if (fromInclusive < toExclusive) {
            int middle = (toExclusive - fromInclusive) / 2 + fromInclusive;
            T object = this.get(middle);
            int comparison = comparator.compare(object);
            if (comparison == 0) {
                return middle;
            }
            if (comparison < 0) {
                return this.binarySearch((T)comparator, middle + 1, toExclusive);
            }
            return this.binarySearch((T)comparator, fromInclusive, middle);
        }
        if (fromInclusive == toExclusive) {
            if (fromInclusive >= this.size) {
                return -this.size - 1;
            }
            if (fromInclusive < 1) {
                return -1;
            }
            T object = this.get(fromInclusive);
            int comparison = comparator.compare(object);
            if (comparison < 0) {
                assert (comparator.compare(this.get(fromInclusive + 1)) > 0);
                return -(fromInclusive + 1) - 1;
            }
            if (comparison > 0) {
                assert (comparator.compare(this.get(fromInclusive - 1)) < 0);
                return -fromInclusive - 1;
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    public int binarySearch(T searchFor) {
        return this.binarySearch(searchFor, 0, this.size);
    }

    public int binarySearch(T searchFor, int fromInclusive, int toExclusive) {
        if (searchFor instanceof Comparable) {
            Comparable searchForComparable = (Comparable)searchFor;
            return this.binarySearch((T)((ICompareAgainst<Object>)o -> -searchForComparable.compareTo(o)), fromInclusive, toExclusive);
        }
        throw new IllegalArgumentException();
    }

    public void clear() {
        this.clearHead(this.size);
    }

    public void clearHead(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        if (this.reallyClear) {
            int endToClear = Math.min(n, this.buffer.length - this.headOffset);
            int headToClear = n - endToClear;
            Arrays.fill(this.buffer, this.headOffset, this.headOffset + endToClear, null);
            Arrays.fill(this.buffer, 0, headToClear, null);
        }
        if (n < this.size) {
            this.headOffset = this.wrapPos(n);
            this.size -= n;
        } else {
            this.headOffset = 0;
            this.size = 0;
        }
    }

    public void clearTail(int n) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException();
        }
        if (this.reallyClear) {
            int endToN = Math.min(this.size, this.buffer.length - this.headOffset);
            int headToN = this.size - endToN;
            int headToClear = Math.min(n, headToN);
            int endToClear = Math.max(n - headToN, 0);
            Arrays.fill(this.buffer, this.buffer.length - endToClear, endToClear, null);
            Arrays.fill(this.buffer, headToN - headToClear, headToClear, null);
        }
        this.size -= n;
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int readPos = this.wrapPos(index);
        T result = this.buffer[readPos];
        return result;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    @Override
    public @NonNull Iterator<T> iterator() {
        return this.iterator(0);
    }

    public @NonNull Iterator<T> iterator(int from) {
        if (from < 0 || from > this.size) {
            throw new IllegalArgumentException();
        }
        return new Iterator<T>(from){
            private int position;
            {
                this.position = n;
            }

            @Override
            public boolean hasNext() {
                return this.position < DynamicArrayRingBuffer.this.size();
            }

            @Override
            public T next() {
                return DynamicArrayRingBuffer.this.get(this.position++);
            }
        };
    }

    public void prepend(T t) {
        this.ensureCapacity();
        int writePos = this.size > 0 ? (this.headOffset > 0 ? this.headOffset - 1 : this.buffer.length - 1) : 0;
        this.buffer[writePos] = t;
        this.headOffset = writePos;
        ++this.size;
    }

    public T removeHead() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        T result = this.buffer[this.headOffset];
        this.buffer[this.headOffset] = null;
        this.headOffset = this.wrapPos(1);
        --this.size;
        return result;
    }

    public @NonNull Iterator<T> reverseIterator() {
        return this.reverseIterator(this.size);
    }

    public @NonNull Iterator<T> reverseIterator(int from) {
        if (from < 0 || from > this.size) {
            throw new IllegalArgumentException();
        }
        int realFrom = from < this.size ? from : this.size - 1;
        return new Iterator<T>(realFrom){
            private int position;
            {
                this.position = n;
            }

            @Override
            public boolean hasNext() {
                return this.position >= 0;
            }

            @Override
            public T next() {
                return DynamicArrayRingBuffer.this.get(this.position--);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(int index, T t) {
        if (index >= 0) {
            if (index < this.size) {
                int writePos = this.wrapPos(index);
                this.buffer[writePos] = t;
                return;
            } else {
                if (index != this.size) throw new IndexOutOfBoundsException();
                this.append(t);
            }
            return;
        } else {
            if (index != -1) throw new IndexOutOfBoundsException();
            this.prepend(t);
        }
    }

    public int size() {
        return this.size;
    }

    private void ensureCapacity() {
        if (this.size + 1 < this.buffer.length) {
            return;
        }
        @Nullable T @NonNull [] tempBuffer = DynamicArrayRingBuffer.newBuffer(Math.max(this.buffer.length * 2, 1024));
        int endToCopy = Math.min(this.size, this.buffer.length - this.headOffset);
        int headToCopy = this.size - endToCopy;
        System.arraycopy(this.buffer, this.headOffset, tempBuffer, 0, endToCopy);
        System.arraycopy(this.buffer, 0, tempBuffer, endToCopy, headToCopy);
        this.headOffset = 0;
        this.buffer = tempBuffer;
    }

    private int wrapPos(int n) {
        assert (n >= 0 && n < this.buffer.length);
        int p = this.headOffset + n;
        return p < this.buffer.length ? p : p - this.buffer.length;
    }

    @FunctionalInterface
    public static interface ICompareAgainst<T> {
        public int compare(T var1);
    }
}

