/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils.collections;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;

public interface Container<T> {
    public boolean contains(T var1);

    public static <T> @NonNull Container<T> wrapCollection(final @NonNull Collection<T> collection) {
        return new Container<T>(){

            @Override
            public boolean contains(T o) {
                return collection.contains(o);
            }
        };
    }

    public static <T extends Comparable<T>> @NonNull Container<T> fromRange(final T begin, final T end) {
        return new Container<T>(){
            static final /* synthetic */ boolean $assertionsDisabled;

            @Override
            public boolean contains(T o) {
                if (!$assertionsDisabled && begin == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && end == null) {
                    throw new AssertionError();
                }
                return begin.compareTo(o) <= 0 && end.compareTo(o) > 0;
            }
        };
    }

    public static <T> @NonNull Container<T> newWithSingleValue(final T value) {
        return new Container<T>(){
            static final /* synthetic */ boolean $assertionsDisabled;

            @Override
            public boolean contains(T o) {
                if (!$assertionsDisabled && value == null) {
                    throw new AssertionError();
                }
                return value.equals(o);
            }
        };
    }

    public static <T> @NonNull Container<T> newWithNothing() {
        return new Container<T>(){

            @Override
            public boolean contains(T o) {
                return false;
            }
        };
    }

    public static <T> @NonNull Container<T> newWithEverything() {
        return new Container<T>(){

            @Override
            public boolean contains(T o) {
                return true;
            }
        };
    }
}

