/*
 * Decompiled with CFR 0.152.
 */
package com.arm.utils;

import gnu.trove.list.TLongList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ListUtils {
    public static <T> void addOrSetAtIndexZero(@NonNull List<T> list, T value) {
        if (list.isEmpty()) {
            list.add(value);
        } else {
            assert (list.size() == 1);
            list.set(0, value);
        }
    }

    public static <T extends Comparable<? super T>> int appendInOrder(@NonNull List<@NonNull T> list, @NonNull T value) {
        ListIterator<@NonNull T> iter = list.listIterator(list.size());
        int steps = 0;
        while (iter.hasPrevious()) {
            if (((Comparable)iter.previous()).compareTo(value) <= 0) {
                iter.next();
                break;
            }
            ++steps;
        }
        iter.add(value);
        return steps;
    }

    public static <T> void convertAndRemoveNull(@NonNull List<T> list, @NonNull Function<? super T, ? extends @Nullable T> converter) {
        int i = 0;
        while (i < list.size()) {
            @Nullable T replacement = converter.apply(list.get(i));
            if (replacement != null) {
                list.set(i, replacement);
            } else {
                list.remove(i);
                --i;
            }
            ++i;
        }
    }

    public static <T> boolean moveBefore(@NonNull List<T> list, int indexToMove, int indexToMoveBefore) {
        if (indexToMove == indexToMoveBefore || indexToMove == indexToMoveBefore - 1) {
            return false;
        }
        T element = list.remove(indexToMove);
        list.add(indexToMove < indexToMoveBefore ? indexToMoveBefore - 1 : indexToMoveBefore, element);
        return true;
    }

    public static void set(@NonNull TLongList list, int index, long value) {
        int size = list.size();
        if (index < size) {
            list.set(index, value);
        } else if (index == size) {
            list.add(value);
        } else {
            throw new AssertionError((Object)"Invalid list index");
        }
    }

    public static <T> void set(@NonNull List<T> list, int index, T value) {
        int size = list.size();
        if (index < size) {
            list.set(index, value);
        } else if (index == size) {
            list.add(value);
        } else {
            throw new AssertionError((Object)"Invalid list index");
        }
    }
}

